unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, System.ComponentModel;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    ColorDialog1: TColorDialog;
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
    FColorBegin,FColorEnd :TColor;
    function ObliczKolor(i :Integer) :TColor;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

function TForm1.ObliczKolor(i :Integer) :TColor;
var W :Integer;
    RedBegin,RedEnd :Byte;
    GreenBegin,GreenEnd :Byte;
    BlueBegin,BlueEnd :Byte;
begin
W:=Width;

RedBegin:=GetRValue(FColorBegin);
GreenBegin:=GetGValue(FColorBegin);
BlueBegin:=GetBValue(FColorBegin);
RedEnd:=GetRValue(FColorEnd);
GreenEnd:=GetGValue(FColorEnd);
BlueEnd:=GetBValue(FColorEnd);

Result:=clNone;
if (i<0) or (i>W) then Exit;
Result:=RGB(
  RedBegin+i*(RedEnd-RedBegin) div W,
  GreenBegin+i*(GreenEnd-GreenBegin) div W,
  BlueBegin+i*(BlueEnd-BlueBegin) div W);
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  i :Integer;
begin
for i:=0 to ClientWidth do
begin
  Canvas.Pen.Color:=ObliczKolor(i);
  Canvas.MoveTo(i,0);
  Canvas.LineTo(i,ClientHeight);
end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
FColorBegin:=clBlue;
FColorEnd:=clBlack;
end;

{$UNSAFECODE ON}
procedure TForm1.Button1Click(Sender: TObject); unsafe;
var PKolor :^TColor;
begin
if (Sender=Button1) then PKolor:=@FColorBegin
                    else PKolor:=@FColorEnd;
ColorDialog1.Color:=PKolor^;
if ColorDialog1.Execute then
  begin
  PKolor^:=ColorDialog1.Color;
  end;
Refresh;
end;
{$UNSAFECODE OFF}

procedure TForm1.FormResize(Sender: TObject);
begin
Button2.Left:=ClientWidth-Button2.Width-Button1.Left;
Refresh;
end;

end.
